// -----------------------------------------------------------------------------
// File Name   : test_aim.c
// Description : 
// SPDX-License-Identifier: MIT
// -----------------------------------------------------------------------------

#include "aim.h"
#include <stdio.h>

int main()
{
  int i;

#if   _AIMER_L == 1
  // Inverted order compared to Sage!
  uint8_t pt[16] =
    {0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00};
  uint8_t ct_expected[16] =
    {0x6b, 0xd8, 0x15, 0xd7, 0x4a, 0x89, 0x68, 0xf2,
     0x02, 0xc6, 0x6c, 0xd7, 0x18, 0x18, 0xfb, 0x54};
  uint8_t iv[16] =
    {0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00};

  uint8_t ct[16] = {0,};

#elif _AIMER_L == 3
  // Inverted order compared to Sage!
  uint8_t pt[24] =
    {0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00,
     0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00};
  uint8_t ct_expected[24] =
    {0xf7, 0xc8, 0xec, 0x53, 0xb3, 0xcc, 0x8b, 0xe8,
     0x99, 0x89, 0xa0, 0xaf, 0x37, 0x2b, 0xb2, 0x23,
     0xb8, 0xc4, 0x57, 0xe9, 0xe2, 0x97, 0x34, 0xd9};
  uint8_t iv[24] =
    {0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00,
     0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00};

  uint8_t ct[24] = {0,};

#elif _AIMER_L == 5
  // Inverted order compared to Sage!
  uint8_t pt[32] =
    {0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00,
     0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00};
  uint8_t ct_expected[32] =
    {0xa4, 0xcd, 0x44, 0x97, 0x0b, 0x83, 0x2d, 0xf6,
     0x16, 0xa4, 0x62, 0xc4, 0xb4, 0xc0, 0x4b, 0x8d,
     0xb2, 0x9e, 0x94, 0x7e, 0xb1, 0x48, 0x93, 0xbe,
     0xcf, 0x22, 0x73, 0xd6, 0x87, 0x67, 0xdb, 0xf6};
  uint8_t iv[32] =
    {0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00,
     0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
     0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00};

  uint8_t ct[32] = {0,};

#endif

  aim(pt, iv, ct);

  printf("PLAINTEXT                 : ");
  for (i = (int)sizeof(pt) - 1; i >= 0; i--)
  {
    printf("%02x", pt[i]);
  }
  printf("\n");

  printf("IV                        : ");
  for (i = (int)sizeof(iv) - 1; i >= 0; i--)
  {
    printf("%02x", iv[i]);
  }
  printf("\n");

  printf("CIPHERTEXT                : ");
  for (i = (int)sizeof(ct) - 1; i >= 0; i--)
  {
    printf("%02x", ct[i]);

    if (ct[i] != ct_expected[i])
    {
      printf("\nError!\n");
      return 0;
    }
  }  
  printf("\nPassed!\n");

  // For  extracting test data -------------------------------------------------
  // printf("CIPHERTEXT(little endian) : ");
  // for (i = 0; i < (int)sizeof(ct) - 1; i++)
  // {
  //   printf("0x%02x, ", ct[i]);
  // }
  // printf("0x%02x\n", ct[i]);
  // For  extracting test data -------------------------------------------------

  return 0;
}
